@extends('layouts.master')
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">

        <div class="card">
            <h5 class="card-header card-title">Add New Camera</h5>
            <div class="table-responsive text-nowrap">
                <form action="{{ route('streamWithCamera.save') }}" method="POST">
                    @csrf

                    <div id="step_1">
                        @include('add.partials.add_camera')
                    </div>
                    <div id="step_2" class="d-none">
                        @include('add.partials.add_region')

                    </div>


                    <div class="row" style="margin: 50px;display: block;text-align: center;;">
                        <button type="button" class="btn btn-default" style="width:150px;" id=""
                            onclick='getStreamMetadata()'> Verify </button>
                        <button type="button" class="btn btn-default" style="width:150px;" id="previous_btn"> Previous
                        </button>
                        <button type="button" class="btn btn-default" style="width:150px;" id="next_btn"> Next </button>
                    </div>

                    <div class="row d-none" style="margin: 50px;display: block;text-align: center;;">
                        <input style="width:150px;" type="submit" value="Submit" class="btn btn-secondary"
                            id="sbmt_btn" />
                    </div>
                </form>
            </div>
            <div class="row">
                <h5>Sample Videos</h5>
                <a href="https://video.codxcanvas.com/people.mp4">https://video.codxcanvas.com/people.mp4</a><br>
                <a href="https://video.codxcanvas.com/sample1.mp4">https://video.codxcanvas.com/sample1.mp4</a><br>
                <a href="https://video.codxcanvas.com/sample1.mp4">https://video.codxcanvas.com/sample1.mp4</a><br>
            </div>
        </div>

        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const step1 = document.getElementById('step_1');
                const step2 = document.getElementById('step_2');
                const nextBtn = document.getElementById('next_btn');
                const prevBtn = document.getElementById('previous_btn');
                const submitBtn = document.getElementById('sbmt_btn');

                // Initially hide the previous button and submit button
                prevBtn.style.display = 'none';
                submitBtn.parentElement.classList.add('d-none');

                nextBtn.addEventListener('click', function() {
                    step1.classList.add('d-none');
                    step2.classList.remove('d-none');
                    prevBtn.style.display = 'inline-block';
                    nextBtn.style.display = 'none';
                    submitBtn.parentElement.classList.remove('d-none');
                });

                prevBtn.addEventListener('click', function() {
                    step2.classList.add('d-none');
                    step1.classList.remove('d-none');
                    prevBtn.style.display = 'none';
                    nextBtn.style.display = 'inline-block';
                    submitBtn.parentElement.classList.add('d-none');
                });
            });




            // ================ VERFIY STREAM URL ================
            function getStreamMetadata() {
                // Get the video URL from the input element with id 'stream_url'
                const videoUrl = document.getElementById('stream_url').value;

                // Make an API call to the Laravel route
                fetch(`/get-stream-metadata?stream_url=${encodeURIComponent(videoUrl)}`)
                    .then(response => response.json()) // Parse JSON response
                    .then(data => {
                        console.log(data); // Log the returned JSON to the console
                    })
                    .catch(error => {
                        console.error('Error fetching stream metadata:', error);
                    });
            }

        
        </script>

        <div class="row" style=" text-align: center; display: block; margin-top: 100px; margin-bottom: 65px; ">
        </div>


    </div>
    </div>



    </div>

@section('script_section')
    <script>
        $(document).ready(function() {
            $('#mySelect').select2();
        });
    </script>
@endSection
@endSection
